#include "openGLControl.h"

// ----------------------------------------------------------------------------------------------------------------------------

class COpenGLWinApp
{
private:
	char *Title;
	int Width, Height, Samples;
	HWND hWnd;
	HGLRC hGLRC;
	POINT LastCurPos;

private:
	COpenGLControl OpenGLControl;

public:
	COpenGLWinApp();
	~COpenGLWinApp();

	bool Init(HINSTANCE hInstance, char *Title, int Width, int Height, int Samples);
	void Show(bool Maximized = false);
	void MessageLoop();
	void Destroy();
	
	void OnKeyDown(UINT Key);
	void OnMouseMove(int cx, int cy);
	void OnPaint();
	void OnRButtonDown(int cx, int cy);
	void OnSize(int Width, int Height);
};

// ----------------------------------------------------------------------------------------------------------------------------

LRESULT CALLBACK WndProc(HWND hWnd, UINT uiMsg, WPARAM wParam, LPARAM lParam);
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR sCmdLine, int iShow);
